/*
 *  arch/arm/mach-uniphier/unit-mn2ws0270_ref/include/unit/hardware.h
 *
 *  Copyright (C) 2011 Panasonic Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef __ASM_UNIT_HARDWARE_H
#define __ASM_UNIT_HARDWARE_H

#ifndef __ASM_ARCH_HARDWARE_H
#error only <mach/hardware.h> can be included directly
#endif

#include <asm/sizes.h>

#define UNIPHIER_PRIVATE_IO_START	0x60000000	/* P.A. */
#define UNIPHIER_PRIVATE_IO_SIZE	0x00002000
#define UNIPHIER_PRIVATE_IO_BASE	0xFE000000	/* V.A. */

#define UNIPHIER_SYS_FLAGSSET_START	0x59801000	/* P.A. */
#define UNIPHIER_SYS_FLAGSSET_SIZE	0x00001000
#define UNIPHIER_SYS_FLAGSSET_BASE	0xFE002000	/* V.A. */

#define UNIPHIER_AIDET_START		0x61830000	/* P.A. */
#define UNIPHIER_AIDET_SIZE		0x00001000
#define UNIPHIER_AIDET_BASE		0xFE003000	/* V.A. */

#define UNIPHIER_SSC_START0		0x500c0000	/* P.A. */
#define UNIPHIER_SSC_SIZE0		0x00001000
#define UNIPHIER_SSC_BASE0		0xFE004000	/* V.A. */

#define UNIPHIER_SSC_START1		0x503c0000	/* P.A. */
#define UNIPHIER_SSC_SIZE1		0x00001000
#define UNIPHIER_SSC_BASE1		0xFE005000	/* V.A. */

#define UNIPHIER_SSC_START2		0x506c0000	/* P.A. */
#define UNIPHIER_SSC_SIZE2		0x00001000
#define UNIPHIER_SSC_BASE2		0xFE006000	/* V.A. */

#define UNIPHIER_TIMER_START		0x54003000	/* P.A. */
#define UNIPHIER_TIMER_SIZE		0x00001000
#define UNIPHIER_TIMER_BASE		0xFE007000	/* V.A. */

#define UNIPHIER_UART_START		0x54006000	/* P.A. */
#define UNIPHIER_UART_SIZE		0x00001000
#define UNIPHIER_UART_BASE		0xFE008000	/* V.A. */

#ifdef CONFIG_SC_UART
#define UNIPHIER_SC_UART_START		0x48200000	/* P.A. */
#define UNIPHIER_SC_UART_SIZE		0x00001000
#define UNIPHIER_SC_UART_BASE		0xFE009000	/* V.A. */
#endif /* CONFIG_SC_UART */

#define UNIPHIER_KERNEL_UNCACHE_START	CONFIG_KERNEL_RAM_BASE_ADDRESS	/* P.A. */
#define UNIPHIER_KERNEL_UNCACHE_SIZE	0x00001000
#define UNIPHIER_KERNEL_UNCACHE_BASE	0xFE00A000	/* V.A. */

#define UNIPHIER_KERNEL_UCWG_SIZE	0x00001000
#define UNIPHIER_KERNEL_UCWG_BASE	0xFE00B000	/* V.A. */

#define UNIPHIER_PURGE_AREA_SIZE	0x00001000	/* per cpu */
#define UNIPHIER_PURGE_AREA_BASE	0xFE00C000	/* V.A. */

#define UNIPHIER_SCU_BASE		(UNIPHIER_PRIVATE_IO_BASE)
#define UNIPHIER_GIC_CPU_START		(UNIPHIER_PRIVATE_IO_START + 0x100)
#define UNIPHIER_GIC_CPU_BASE		(UNIPHIER_PRIVATE_IO_BASE + 0x100)
#define UNIPHIER_GIC_DIST_START		(UNIPHIER_PRIVATE_IO_START + 0x1000)
#define UNIPHIER_GIC_DIST_BASE		(UNIPHIER_PRIVATE_IO_BASE + 0x1000)
#define UNIPHIER_TWD_BASE		(UNIPHIER_PRIVATE_IO_BASE + 0x600)

#define UNIPHIER_GLOBAL_TIMER_SRC	50000000

#define UNIPHIER_UART0_START		0x54006800	/* P.A. */
#define UNIPHIER_UART0_BASE		(UNIPHIER_UART0_START - \
					 UNIPHIER_UART_START + \
					 UNIPHIER_UART_BASE)

#define UNIPHIER_UART1_START		0x54006900	/* P.A. */
#define UNIPHIER_UART1_BASE		(UNIPHIER_UART1_START - \
					 UNIPHIER_UART_START + \
					 UNIPHIER_UART_BASE)

#define UNIPHIER_UART2_START		0x54006A00	/* P.A. */
#define UNIPHIER_UART2_BASE		(UNIPHIER_UART2_START - \
					 UNIPHIER_UART_START + \
					 UNIPHIER_UART_BASE)

#define UNIPHIER_UART3_START		0x54006B00	/* P.A. */
#define UNIPHIER_UART3_BASE		(UNIPHIER_UART3_START - \
					 UNIPHIER_UART_START + \
					 UNIPHIER_UART_BASE)

#define SSC_OFFSET_BASE			0x50000000

#define UNIPHIER_SYSTEM_CTL_REG_BASE	0x61840000
#define UNIPHIER_SYSTEM_CTL_REG_SIZE	0x00010000

#define UNIPHIER_SG_CTRL_REG_BASE	0x5F800000
#define UNIPHIER_SG_CTRL_REG_SIZE	0x00100000

#define BOOTLOADER_START		0xC0A00000
#define BOOTLOADER_SIZE			0x00400000

#endif /* __ASM_UNIT_HARDWARE_H */
